<?php
/**
 * Setup theme
 *
 * @package Nisje
 */

declare( strict_types=1 );
namespace NisjeFrontend\Setup;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Silence is golden.' );
}

/**
 * Setup Theme Functionality
 */
function setup_theme_functionality() {
	// Register default Menu.
	register_nav_menu( 'primary', esc_html__( 'Primary Menu', 'nisje-theme' ) );
	register_nav_menu( 'shortcuts', esc_html__( 'Shortcuts Menu', 'nisje-theme' ) );

	// Add title tag.
	add_theme_support( 'title-tag' );

	// Use nouveau theme in BuddyPress.
	add_theme_support( 'buddypress-use-nouveau' );

	// Add post thumbnails.
	add_theme_support( 'post-thumbnails' );

	// Enable support for custom logo.
	add_theme_support( 'custom-logo', [
		'height'      => 240,
		'width'       => 240,
		'flex-height' => true,
		'flex-width'  => true,
	] );

	// Indicate widget sidebars can use selective refresh in the Customizer.
	add_theme_support( 'customize-selective-refresh-widgets' );

	// Add support for full and wide align blocks.
	add_theme_support( 'align-wide' );

	// Add support for responsive embeds.
	add_theme_support( 'responsive-embeds' );
}
add_action( 'after_setup_theme', __NAMESPACE__ . '\\setup_theme_functionality' );

/**
 * Set default avatar
 *
 * The react app will create svg fallback if it picks up the url fallback.
 */
function default_avatar(): string {
	return 'fallback';
}

add_action( 'init', function() {
	add_filter( 'bp_core_avatar_default', __NAMESPACE__ . '\\default_avatar' );
	add_filter( 'bp_core_fetch_avatar_no_grav', '__return_true' );
} );
