<?php
/**
 * Register functionality
 *
 * @package Nisje
 */

declare( strict_types=1 );
namespace NisjeFrontend\Register;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Silence is golden.' );
}

/**
 * Disable wysiwyg.
 */
add_filter( 'bp_xprofile_is_richtext_enabled_for_field', '__return_false', 10 );

/**
 * Register logo
 */
function logo() {
	\NisjeFrontend\inc( 'components', 'logo-banner' );
}
add_action( 'bp_before_register_page', __NAMESPACE__ . '\\logo' );
add_action( 'bp_before_activation_page', __NAMESPACE__ . '\\logo' );

/**
 * Background image
 */
function background() {
	$background_image = get_theme_mod( 'nisje_theme_images_register_background', false );

	if ( ! empty( $background_image ) ) {
		\NisjeFrontend\inc( 'components', 'background-image', [
			'url' => $background_image,
		] );
	}
}
add_action( 'bp_after_register_page', __NAMESPACE__ . '\\background' );
add_action( 'bp_after_activation_page', __NAMESPACE__ . '\\background' );
