<?php
/**
 * Server-side rendering of the `nisje/links` block.
 *
 * @package Nisje
 */

namespace Nisje\BlockLibrary\CardLinks;

/**
 * Renders the `nisje/links` block on server
 *
 * @param array $attributes The block attributes.
 * @return string Returns the post content with links added.
 */
function render_block( array $attributes ): string {
	$content = [
		'type'   => 'links',
		'title'  => $attributes['title'],
		'isDark' => $attributes['isDark'],
		'items'  => $attributes['items'],
	];

	if ( isset( $attributes['backgroundColor'] ) ) {
		$content['className'] = "has-{$attributes['backgroundColor']}-background-color";
	} elseif ( isset( $attributes['customBackgroundColor'] ) ) {
		$content['bg'] = $attributes['customBackgroundColor'];
	}

	return \wp_json_encode( $content );
}

/**
 * Registers the `nisje/links` block on server.
 */
function register_block(): void {
	\register_block_type_from_metadata( __DIR__, [
		'render_callback' => __NAMESPACE__ . '\\render_block',
	] );
}
\add_action( 'init', __NAMESPACE__ . '\\register_block' );
