<?php
/**
 * Customizer assets.
 *
 * @package nisje
 */

declare( strict_types=1 );
namespace NisjeFrontend\Customizer\Assets;

use NisjeFrontend\Customizer;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Silence is golden.' );
}

/**
 * Load dynamic logic for the customizer controls area.
 */
function panels() {
	wp_enqueue_script(
		'nisje-customize-controls',
		get_theme_file_uri( '/lib/customizer/js/customizer-controls.js' ),
		[],
		NISJE_THEME_VERSION,
		true
	);
}
add_action( 'customize_controls_enqueue_scripts', __NAMESPACE__ . '\\panels' );

/**
 * Bind JS handlers to instantly live-preview changes.
 */
function preview() {
	wp_enqueue_script(
		'nisje-customize-preview',
		get_theme_file_uri( '/lib/customizer/js/customizer-preview.js' ),
		[ 'customize-preview' ],
		NISJE_THEME_VERSION,
		true
	);

	wp_add_inline_script(
		'nisje-customize-preview',
		'var nisjeCustomizerSections = ' . wp_json_encode( Customizer\get_customizer_settings() ) . ';',
		'before'
	);
}
add_action( 'customize_preview_init', __NAMESPACE__ . '\\preview' );
