<?php
/**
 * Component: Logo Banner
 *
 * @package Nisje
 */

declare( strict_types = 1 );

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$defaults = [
	'message' => '',
];

$args = wp_parse_args( $args, $defaults );

?>
<header class="nisje-login-header">
	<div class="nisje-logo-banner">
		<?php
		printf( '<img class="nisje-logo-banner__logo" src="%s" alt="%s">',
			esc_attr( get_theme_mod( 'nisje_theme_images_login_logo' ) ),
			esc_attr( get_bloginfo( 'name' ) )
		);
		?>
	</div>
	<?php
	if ( ! empty( $args['message'] ) ) {
		printf( '<div class="nisje-login-header__message"><p class="message">%s</p></div>',
			esc_html( $args['message'] )
		);
	}
	?>
</header>
