<?php
/**
 * Theme helpers
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace NisjeFrontend;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Load templates from the template-parts folder
 *
 * @param string $type Type of component.
 * @param string $component File name of the component.
 * @param array  $args Value param to pass to the component.
 * @param string $path Path to the template-parts folder.
 */
function inc( string $type, string $component, array $args = [], string $path = 'template-parts' ) {
	$templates = [
		"{$path}/{$type}/{$component}.php",
	];

	$template = locate_template( $templates );

	if ( $template && 0 === validate_file( $template ) ) {
		include $template;
	} elseif ( WP_DEBUG ) {
		echo esc_html( 'CANNOT FIND COMPONENT(S): "' . implode( '\' or \'', $templates ) . '"' );
	}
}


/**
 * Gets the templates from the template-parts folder.
 *
 * @param string $type Type of component.
 * @param string $component File name of the component.
 * @param array  $args Value param to pass to the component.
 * @param string $path Path to the template-parts folder.
 *
 * @return string The component
 */
function get( string $type, string $component, array $args = [], string $path = 'template-parts' ) : string {
	ob_start();
	inc( $type, $component, $args, $path );
	$output = ob_get_contents();
	ob_end_clean();

	return $output;
}
