( function( _, wp ) {
	wp.customize.bind( 'ready', function() {
		_.each( wp.customize.panel( 'nisje_theme' ).sections(), function( section ) {
			_.each( section.controls(), function( control ) {
				if ( control.templateSelector === 'customize-control-toggle_switch-content' ) {
					wp.customize( control.id, function( toggle ) {
						const controlBaseId = control.id.replace( 'toggle', '' );

						_.each( [ 'color_1', 'color_2' ], function( colorId ) {
							wp.customize.control( controlBaseId + colorId, function( colorControl ) {
								function visibility() {
									if ( toggle.get() ) {
										colorControl.container.show();
									} else {
										colorControl.container.hide();
									}
								}

								visibility();
								toggle.bind( visibility );
							} );
						} );
					} );
				}
			} );
		} );
	} );
} )( window._, window.wp );
