<?php
/**
 * Custom controls for the customizer
 *
 * @package Nisje
 */

declare( strict_types=1 );
namespace NisjeFrontend\Customizer\Controls;

if ( class_exists( 'WP_Customize_Control' ) ) {
	/**
	 * Toggle Switch Custom Control
	 */
	class Toggle_Switch extends \WP_Customize_Control {
		/**
		 * The type of control being rendered
		 *
		 * @var string
		 */
		public $type = 'toggle_switch';

		/**
		 * Enqueue styles
		 */
		public function enqueue() {
			wp_enqueue_style(
				'nisje-customizer',
				get_theme_file_uri( '/lib/customizer/css/toggle-switch.css' ),
				[],
				NISJE_THEME_VERSION,
				'all'
			);
		}

		/**
		 * Render the control in the customizer
		 */
		public function render_content() {
			?>
			<div class="toggle-switch-control">
				<div class="toggle-switch">
					<input type="checkbox" id="<?php echo esc_attr( $this->id ); ?>" name="<?php echo esc_attr( $this->id ); ?>" class="toggle-switch-checkbox" value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); ?><?php checked( $this->value() ); ?> />
					<label class="toggle-switch-label" for="<?php echo esc_attr( $this->id ); ?>">
						<span class="toggle-switch-inner"></span>
					</label>
				</div>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
			</div>
			<?php
		}
	}
}
