<?php
/**
 * Menu related functions for the Nisje.
 *
 * @package nisje
 */

declare( strict_types=1 );
namespace NisjeFrontend\Menu;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Silence is golden.' );
}

/**
 * Add ACF menu fields.
 */
function register_menu_fields() {
	acf_add_local_field_group( [
		'key'                   => 'group_5c58dd25933f3',
		'title'                 => 'Menu',
		'fields'                => [
			[
				'key'           => 'field_5c58dd2847ab2',
				'label'         => 'Require user to show this menu item',
				'name'          => 'require_user',
				'type'          => 'true_false',
				'instructions'  => '',
				'required'      => 0,
				'message'       => '',
				'default_value' => 0,
				'ui'            => 0,
				'ui_on_text'    => '',
				'ui_off_text'   => '',
			],
		],
		'location'              => [
			[
				[
					'param'    => 'nav_menu_item',
					'operator' => '==',
					'value'    => 'all',
				],
			],
		],
		'menu_order'            => 0,
		'position'              => 'normal',
		'style'                 => 'default',
		'label_placement'       => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen'        => '',
		'active'                => 1,
		'description'           => '',
	] );
}
add_action( 'nisje_register_acf_fields', __NAMESPACE__ . '\\register_menu_fields' );
