<?php
/**
 * Reset
 *
 * @package Nisje
 */

declare( strict_types=1 );
namespace NisjeFrontend\Reset;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Silence is golden.' );
}

// Do not redirect canonical.
remove_filter( 'template_redirect', 'redirect_canonical' );

/**
 * Cleanup wp_head
 */
function cleanup_wp_head() {
	remove_action( 'wp_head', 'feed_links', 2 );
	remove_action( 'wp_head', 'feed_links_extra', 3 );
	remove_action( 'wp_head', 'index_rel_link' );
	remove_action( 'wp_head', 'parent_post_rel_link', 10, 0 );
	remove_action( 'wp_head', 'start_post_rel_link', 10, 0 );
	remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );
	remove_action( 'wp_head', 'wp_shortlink_wp_head', 10, 0 );
	remove_action( 'wp_head', 'wp_generator' );
	remove_action( 'wp_head', 'rel_canonical' );
	remove_action( 'wp_head', 'wp_resource_hints', 2 );
}
add_action( 'init', __NAMESPACE__ . '\\cleanup_wp_head' );

/**
 * Force site name if 404.
 *
 * @param string $title The document title. Default empty string.
 */
function title( string $title ) : string {
	if ( is_404() ) {
		$title = get_bloginfo( 'name', 'display' );
	}

	return $title;
}
add_filter( 'pre_get_document_title', __NAMESPACE__ . '\\title' );
