<?php
/**
 * Setup theme
 *
 * @package Nisje
 */

declare( strict_types=1 );
namespace NisjeFrontend\Setup;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Silence is golden.' );
}

/**
 * Setup Theme Functionality
 */
function setup_theme_functionality() {
	// Register default Menu.
	register_nav_menu( 'primary', esc_html__( 'Primary Menu', 'nisje' ) );
	register_nav_menu( 'shortcuts', esc_html__( 'Shortcuts Menu', 'nisje' ) );

	// Add title tag.
	add_theme_support( 'title-tag' );

	// Use nouveau theme in BuddyPress.
	add_theme_support( 'buddypress-use-nouveau' );

	// Add post thumbnails.
	add_theme_support( 'post-thumbnails' );

	// Enable support for custom logo.
	add_theme_support( 'custom-logo', [
		'height'      => 240,
		'width'       => 240,
		'flex-height' => true,
		'flex-width'  => true,
	] );

	// Indicate widget sidebars can use selective refresh in the Customizer.
	add_theme_support( 'customize-selective-refresh-widgets' );

	// Add support for full and wide align blocks.
	add_theme_support( 'align-wide' );

	// Add support for responsive embeds.
	add_theme_support( 'responsive-embeds' );

	$color_palette = \apply_filters( 'nisje_editor_color_palette', [] );
	if ( ! empty( $color_palette ) ) {
		add_theme_support( 'editor-color-palette', $color_palette );
	}
}
add_action( 'after_setup_theme', __NAMESPACE__ . '\\setup_theme_functionality' );

/**
 * Remove unused widgets.
 */
function remove_widgets() {
	// WP Core Widgets.
	unregister_widget( 'WP_Widget_Pages' );
	unregister_widget( 'WP_Widget_Calendar' );
	unregister_widget( 'WP_Widget_Archives' );
	unregister_widget( 'WP_Widget_Links' );
	unregister_widget( 'WP_Widget_Media_Audio' );
	unregister_widget( 'WP_Widget_Media_Image' );
	unregister_widget( 'WP_Widget_Media_Video' );
	unregister_widget( 'WP_Widget_Media_Gallery' );
	unregister_widget( 'WP_Widget_Meta' );
	unregister_widget( 'WP_Widget_Search' );
	unregister_widget( 'WP_Widget_Text' );
	unregister_widget( 'WP_Widget_Categories' );
	unregister_widget( 'WP_Widget_Recent_Posts' );
	unregister_widget( 'WP_Widget_Recent_Comments' );
	unregister_widget( 'WP_Widget_RSS' );
	unregister_widget( 'WP_Widget_Tag_Cloud' );
	unregister_widget( 'WP_Nav_Menu_Widget' );
	unregister_widget( 'WP_Widget_Custom_HTML' );

	// BuddyPress Widgets.
	unregister_widget( 'BP_Core_Login_Widget' );
	unregister_widget( 'BP_Messages_Sitewide_Notices_Widget' );
	unregister_widget( 'BP_Core_Recently_Active_Widget' );
	unregister_widget( 'BP_Core_Whos_Online_Widget' );
	unregister_widget( 'BP_Blogs_Recent_Posts_Widget' );
	unregister_widget( 'BP_Core_Members_Widget' );
	unregister_widget( 'BP_Nouveau_Object_Nav_Widget' );
	unregister_widget( 'BP_Latest_Activities' );
	unregister_widget( 'BP_Groups_Widget' );
	unregister_widget( 'BP_Core_Friends_Widget' );

	// BuddyPress Sidebars.
	unregister_sidebar( 'sidebar-buddypress-members' );
	unregister_sidebar( 'sidebar-buddypress-groups' );
}
add_action( 'widgets_init', __NAMESPACE__ . '\\remove_widgets', 20 );

/**
 * Set default avatar
 *
 * The react app will create svg fallback if it picks up the url fallback.
 *
 * @param string $avatar Default avatar.
 */
function default_avatar( $avatar ): string {
	if ( \is_admin() ) {
		return $avatar;
	}

	return 'fallback';
}

add_action( 'init', function() {
	add_filter( 'bp_core_avatar_default', __NAMESPACE__ . '\\default_avatar' );
	add_filter( 'bp_core_default_avatar_group', __NAMESPACE__ . '\\default_avatar' );
	add_filter( 'bp_core_fetch_avatar_no_grav', '__return_true' );
} );

/**
 * Remove BuddyPress blocks.
 */
add_action( 'init', function() {
	add_filter( 'bp_friends_register_blocks', '__return_empty_array' );
	add_filter( 'bp_notifications_register_blocks', '__return_empty_array' );
	add_filter( 'bp_groups_register_blocks', '__return_empty_array' );
	add_filter( 'bp_members_register_blocks', '__return_empty_array' );
	add_filter( 'bp_activity_register_blocks', '__return_empty_array' );
}, 1 );
