<?php
/**
 * Internationalization-related functions for the Nisje.
 *
 * @package nisje
 */

declare( strict_types=1 );
namespace NisjeFrontend\Customizer;

use NisjeFrontend\Customizer\Controls;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Silence is golden.' );
}

/**
 * Get settings
 */
function get_customizer_settings(): array {
	$theme_primary    = '#00579e';
	$theme_on_primary = '#ffffff';

	// Toolbar.
	$theme_toolbar_background = '#1e2329';
	$theme_toolbar_border     = '#353535';
	$theme_toolbar_icons      = '#ffffff';

	return [
		'general'     => [
			'label'  => __( 'General', 'nisje' ),
			'key'    => '--theme-',
			'colors' => [
				'primary' => [
					'label'   => __( 'Primary', 'nisje' ),
					'default' => [ $theme_primary, $theme_on_primary ],
				],
			],
		],
		'login'       => [
			'label'  => __( 'Login', 'nisje' ),
			'key'    => '--login-',
			'images' => [
				'logo'       => __( 'Logo', 'nisje' ),
				'background' => __( 'Background image', 'nisje' ),
			],
			'colors' => [
				'banner' => [
					'label'   => __( 'Banner', 'nisje' ),
					'default' => [ '#333333', '#ffffff' ],
				],
			],
		],
		'register'    => [
			'label'  => __( 'Register', 'nisje' ),
			'key'    => '--register-',
			'images' => [
				'background' => __( 'Background image', 'nisje' ),
			],
			'colors' => [],
		],
		'toolbar'     => [
			'label'  => __( 'Toolbar', 'nisje' ),
			'key'    => '--theme-toolbar-',
			'images' => [
				'logo' => __( 'Logo', 'nisje' ),
			],
			'colors' => [
				'background'  => [
					'label'   => __( 'Background', 'nisje' ),
					'default' => [ $theme_toolbar_background ],
				],
				'border'      => [
					'label'   => __( 'Border', 'nisje' ),
					'default' => [ $theme_toolbar_border ],
				],
				'icons'       => [
					'label'   => __( 'Icons', 'nisje' ),
					'default' => [ $theme_toolbar_icons ],
				],
				'icons-hover' => [
					'label'   => __( 'Icons (hover)', 'nisje' ),
					'default' => [ $theme_toolbar_icons ],
				],
			],
		],
		'sidebar'     => [
			'label'  => __( 'Sidebar', 'nisje' ),
			'key'    => '--theme-sidebar-',
			'colors' => [
				'background'        => [
					'label'   => __( 'Background', 'nisje' ),
					'default' => [ '#22262a', '#ffffff' ],
				],
				'background-hover'  => [
					'label'   => __( 'Link hover', 'nisje' ),
					'default' => [ '#22262a', '#ffffff' ],
				],
				'background-active' => [
					'label'   => __( 'Link active', 'nisje' ),
					'default' => [ '#22262a', '#ffffff' ],
				],
				'share'             => [
					'label'   => __( 'Share button', 'nisje' ),
					'default' => [ '#0097ff', '#ffffff' ],
				],
				'share-hover'       => [
					'label'   => __( 'Share button hover', 'nisje' ),
					'default' => [ '#ffffff', '#435c70' ],
				],
			],
		],
		'sidebar-alt' => [
			'label'  => __( 'Secondary Sidebar', 'nisje' ),
			'key'    => '--theme-sidebar-secondary-',
			'colors' => [
				'color'       => [
					'label'   => __( 'Color', 'nisje' ),
					'default' => [ '#435c70' ],
				],
				'hover'       => [
					'label'   => __( 'Link hover', 'nisje' ),
					'default' => [ '#edf2f5', '#435c70' ],
				],
				'active'      => [
					'label'   => __( 'Link active', 'nisje' ),
					'default' => [ '#edf2f5', '#435c70' ],
				],
				'share'       => [
					'label'   => __( 'Share button', 'nisje' ),
					'default' => [ '#0097ff', '#ffffff' ],
				],
				'share-hover' => [
					'label'   => __( 'Share button hover', 'nisje' ),
					'default' => [ '#ffffff', '#435c70' ],
				],
			],
		],
		'forms'       => [
			'label'  => __( 'Forms', 'nisje' ),
			'key'    => '--theme-form-',
			'colors' => [
				'primary' => [
					'label'              => __( 'Primary', 'nisje' ),
					'default'            => [ 'var(--theme-primary)', 'var(--theme-on-primary)' ],
					'customizer_default' => [ $theme_primary, $theme_on_primary ],
				],
			],
		],
		'events'      => [
			'label'  => __( 'Events', 'nisje' ),
			'key'    => '--theme-events-',
			'colors' => [
				'background' => [
					'label'   => __( 'Background', 'nisje' ),
					'default' => [ '#ff2e79', '#ffffff' ],
				],
			],
		],
		'editorial'   => [
			'label'  => __( 'Editorial', 'nisje' ),
			'key'    => '--theme-editorial-',
			'colors' => [
				'background' => [
					'label'   => __( 'Background (top level)', 'nisje' ),
					'default' => [ '#22262a', '#ffffff' ],
				],
			],
		],
	];
}

/**
 * Register customizer settings
 *
 * @param \WP_Customize_Manager $wp_customize Customizer controller.
 */
function register( \WP_Customize_Manager $wp_customize ) {
	$panel_key = 'nisje_theme';

	$wp_customize->add_panel( $panel_key, [
		'priority' => 30,
		'title'    => __( 'Nisje', 'nisje' ),
	] );

	$theme_colors = get_customizer_settings();

	foreach ( $theme_colors as $group_key => $group ) {
		$section_key = $panel_key . '_' . $group_key;

		$wp_customize->add_section( $section_key, [
			'title' => $group['label'],
			'panel' => $panel_key,
		] );

		if ( isset( $group['images'] ) ) {
			foreach ( $group['images'] as $key => $label ) {
				$image_key = $panel_key . '_images_' . $group_key . '_' . $key;

				$wp_customize->add_setting(
					$image_key,
					[
						'sanitize_callback' => 'esc_url_raw',
					]
				);

				$wp_customize->add_control(
					new \WP_Customize_Image_Control(
						$wp_customize,
						$image_key,
						[
							'label'    => $label,
							'section'  => $section_key,
							'settings' => $image_key,
						]
					)
				);
			}
		}

		foreach ( $group['colors'] as $key => $value ) {
			$color_key = $panel_key . '_colors_' . $group_key . '_' . $key;

			$wp_customize->add_setting(
				$color_key . '_toggle',
				[
					'default'   => 0,
					'transport' => 'postMessage',
				]
			);

			$wp_customize->add_control(
				new Controls\Toggle_Switch(
					$wp_customize,
					$color_key . '_toggle',
					[
						'label'   => $value['label'],
						'section' => $section_key,
					]
				)
			);

			$defaults = isset( $value['customizer_default'] ) ? $value['customizer_default'] : $value['default'];

			foreach ( $defaults as $index => $default ) {
				$index_key = $color_key . '_color_' . ( $index + 1 );

				$wp_customize->add_setting(
					$index_key,
					[
						'default'           => $default,
						'sanitize_callback' => 'sanitize_hex_color',
						'transport'         => 'postMessage',
					]
				);

				$wp_customize->add_control(
					new \WP_Customize_Color_Control(
						$wp_customize,
						$index_key,
						[
							'label'   => 0 === $index ? 'Color' : 'On color',
							'section' => $section_key,
						]
					)
				);
			}
		}
	}
}
add_action( 'customize_register', __NAMESPACE__ . '\\register' );

/**
 * Display custom color CSS in customizer and on frontend.
 */
function colors_css_wrap() {
	// Only include custom colors in customizer or frontend.
	if ( is_admin() ) {
		return;
	}

	$theme_colors      = get_customizer_settings();
	$cusomtized_colors = [];

	foreach ( $theme_colors as $group_key => $group ) {
		foreach ( $group['colors'] as $key => $color ) {
			$key_base = 'nisje_theme_colors_' . $group_key . '_' . $key;

			if ( get_theme_mod( $key_base . '_toggle', false ) ) {
				foreach ( $color['default'] as $index => $default ) {
					$css_key = 0 === $index ? '' : 'on-';
					$cusomtized_colors[ $group['key'] . $css_key . $key ] = get_theme_mod( $key_base . '_color_' . ( $index + 1 ), $default );
				}
			}
		}
	}

	if ( empty( $cusomtized_colors ) ) {
		return;
	}
	?>
	<style type="text/css">
		:root {
			<?php
			foreach ( $cusomtized_colors as $key => $color ) {
				printf( '%s:%s;',
					esc_html( $key ),
					esc_html( $color )
				);
			}
			?>
		}
	</style>
	<?php
}
add_action( 'wp_head', __NAMESPACE__ . '\\colors_css_wrap' );
add_action( 'login_head', __NAMESPACE__ . '\\colors_css_wrap' );
