<?php
/**
 * Update theme.
 *
 * @package nisje
 */

declare( strict_types=1 );
namespace NisjeFrontend\Update;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Silence is golden.' );
}

/**
 * Remove update nag
 */
function hide_update_nag() {
	\remove_action( 'admin_notices', 'update_nag', 3 );
}
\add_action( 'admin_head', __NAMESPACE__ . '\\hide_update_nag', 1 );

/**
 * Update theme
 */
function update() {
	$option_key = 'nisje_theme_version';

	$current_version      = wp_get_theme()->get( 'Version' );
	$last_updated_version = get_option( $option_key, '0.0.0' );

	if ( $last_updated_version !== $current_version ) {
		/**
		 * 1.8.2
		 */
		if ( version_compare( '1.8.2', $last_updated_version, '>' ) ) {
			$toolbar_background  = get_theme_mod( 'nav-bg-narrow' );
			$toolbar_color       = get_theme_mod( 'nav-menu-toggle' );
			$toolbar_color_hover = get_theme_mod( 'nav-icon-hover' );

			set_theme_mod( 'nisje_theme_colors_toolbar_background_toggle', ! empty( $toolbar_background ) );
			set_theme_mod( 'nisje_theme_colors_toolbar_background_color_1', $toolbar_background );
			set_theme_mod( 'nisje_theme_colors_toolbar_icons_toggle', ! empty( $toolbar_color ) );
			set_theme_mod( 'nisje_theme_colors_toolbar_icons_color_1', $toolbar_color );
			set_theme_mod( 'nisje_theme_colors_toolbar_icons-hover_toggle', ! empty( $toolbar_color_hover ) );
			set_theme_mod( 'nisje_theme_colors_toolbar_icons-hover_color_1', $toolbar_color_hover );
		}

		/**
		 * 1.8.4
		 */
		if ( version_compare( '1.8.4', $last_updated_version, '>' ) ) {
			$toolbar_border = get_theme_mod( 'nav-border' );

			set_theme_mod( 'nisje_theme_colors_toolbar_border_toggle', ! empty( $toolbar_border ) );
			set_theme_mod( 'nisje_theme_colors_toolbar_border_color_1', $toolbar_border );
		}

		/**
		 * 1.9.0
		 */
		if ( version_compare( '1.9.0', $last_updated_version, '>' ) ) {
			$login_banner = get_theme_mod( 'nav-bg-main' );

			set_theme_mod( 'nisje_theme_colors_login_banner_toggle', ! empty( $login_banner ) );
			set_theme_mod( 'nisje_theme_colors_login_banner_color_1', $login_banner );

			if ( function_exists( 'nisje_get_setting' ) ) {
				$login_logo = nisje_get_setting( 'login_logo', 'general' );
				if ( ! empty( $login_logo ) ) {
					set_theme_mod( 'nisje_theme_images_login_logo', $login_logo );
				}

				$toolbar_logo = nisje_get_setting( 'toolbar_logo', 'general' );
				if ( ! empty( $toolbar_logo ) ) {
					set_theme_mod( 'nisje_theme_images_toolbar_logo', $toolbar_logo );
				}
			}
		}

		/**
		 * 2.4.2
		 */
		if ( version_compare( '2.4.2', $last_updated_version, '>' ) ) {
			$events_background = get_theme_mod( 'circle-event-date', '#ff2e79' );
			$events_text       = get_theme_mod( 'circle-event-date-color', '#ffffff' );
			set_theme_mod( 'nisje_theme_colors_events_background_toggle', ! empty( $events_background ) );
			set_theme_mod( 'nisje_theme_colors_events_background_color_1', $events_background );
			set_theme_mod( 'nisje_theme_colors_events_background_color_2', $events_text );

			$editorial_background = get_theme_mod( 'box-top-leve-editorial-bg', '#22262a' );
			$editorial_text       = get_theme_mod( 'box-top-leve-editorial', '#ffffff' );
			set_theme_mod( 'nisje_theme_colors_editorial_background_toggle', ! empty( $editorial_background ) );
			set_theme_mod( 'nisje_theme_colors_editorial_background_color_1', $editorial_background );
			set_theme_mod( 'nisje_theme_colors_editorial_background_color_2', $editorial_text );

			$sidebar_background = get_theme_mod( 'nav-bg-main', '#22262a' );
			$sidebar_text       = get_theme_mod( 'nav-text', '#ffffff' );
			set_theme_mod( 'nisje_theme_colors_sidebar_background_toggle', ! empty( $sidebar_background ) );
			set_theme_mod( 'nisje_theme_colors_sidebar_background_color_1', $sidebar_background );
			set_theme_mod( 'nisje_theme_colors_sidebar_background_color_2', $sidebar_text );

			$sidebar_hover_background = get_theme_mod( 'nav-hover-bg', '#0092ef' );
			$sidebar_hover_text       = get_theme_mod( 'nav-text-hover', '#ffffff' );
			set_theme_mod( 'nisje_theme_colors_sidebar_background-hover_toggle', ! empty( $sidebar_hover_background ) );
			set_theme_mod( 'nisje_theme_colors_sidebar_background-hover_color_1', $sidebar_hover_background );
			set_theme_mod( 'nisje_theme_colors_sidebar_background-hover_color_2', $sidebar_hover_text );

			$sidebar_active_background = get_theme_mod( 'nav-selected-bg', '#0094ff' );
			set_theme_mod( 'nisje_theme_colors_sidebar_background-active_toggle', ! empty( $sidebar_active_background ) );
			set_theme_mod( 'nisje_theme_colors_sidebar_background-active_color_1', $sidebar_active_background );
			set_theme_mod( 'nisje_theme_colors_sidebar_background-active_color_2', $sidebar_text );

			$sidebar_share_background = get_theme_mod( 'nav-group-nav', '#0097ff' );
			$sidebar_share_text       = get_theme_mod( 'nav-share-text', '#ffffff' );
			set_theme_mod( 'nisje_theme_colors_sidebar_share_toggle', ! empty( $sidebar_share_background ) );
			set_theme_mod( 'nisje_theme_colors_sidebar_share_color_1', $sidebar_share_background );
			set_theme_mod( 'nisje_theme_colors_sidebar_share_color_2', $sidebar_share_text );

			$sidebar_share_hover_background = get_theme_mod( 'nav-share-bg-hover', '#ffffff' );
			$sidebar_share_hover_text       = get_theme_mod( 'nav-share-text-hover', '#435c70' );
			set_theme_mod( 'nisje_theme_colors_sidebar_share-hover_toggle', ! empty( $sidebar_share_hover_background ) );
			set_theme_mod( 'nisje_theme_colors_sidebar_share-hover_color_1', $sidebar_share_hover_background );
			set_theme_mod( 'nisje_theme_colors_sidebar_share-hover_color_2', $sidebar_share_hover_text );

			$alt_text = get_theme_mod( 'nav-group-nav-text', '#435c70' );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_color_toggle', ! empty( $alt_text ) );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_color_color_1', $alt_text );

			$alt_hover_background = get_theme_mod( 'nav-group-nav-bg-hover', '#edf2f5' );
			$alt_hover_text       = get_theme_mod( 'nav-group-nav-text-hover', '#435c70' );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_hover_toggle', ! empty( $alt_hover_background ) );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_hover_color_1', $alt_hover_background );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_hover_color_2', $alt_hover_text );

			$alt_active_background = get_theme_mod( 'nav-group-nav-bg', '#edf2f5' );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_active_toggle', ! empty( $alt_active_background ) );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_active_color_1', $alt_active_background );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_active_color_2', $alt_hover_text );

			$alt_share_background = get_theme_mod( 'nav-group-share-bg', '#0097ff' );
			$alt_share_text       = get_theme_mod( 'nav-group-share-text', '#ffffff' );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_share_toggle', ! empty( $alt_share_background ) );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_share_color_1', $alt_share_background );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_share_color_2', $alt_share_text );

			$alt_share_hover_background = get_theme_mod( 'nav-group-share-bg-hover', '#0097ff' );
			$alt_share_hover_text       = get_theme_mod( 'nav-group-share-text-hover', '#ffffff' );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_share-hover_toggle', ! empty( $alt_share_hover_background ) );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_share-hover_color_1', $alt_share_hover_background );
			set_theme_mod( 'nisje_theme_colors_sidebar-alt_share-hover_color_2', $alt_share_hover_text );
		}

		/**
		 * Store last updated version
		 */
		update_option( $option_key, $current_version );

		flush_rewrite_rules();
	}
}
add_action( 'after_setup_theme', __NAMESPACE__ . '\\update', 10 );
