<?php
/**
 * Component: Logo Banner
 *
 * @package Nisje
 */

declare( strict_types = 1 );

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$defaults = [
	'message' => '',
];

$args = wp_parse_args( $args, $defaults );

$logo        = get_theme_mod( 'nisje_theme_images_login_logo' );
$has_logo    = ! empty( $logo );
$has_message = ! empty( $args['message'] );
?>
<header class="nisje-login-header">
	<?php if ( ! empty( get_theme_mod( 'nisje_theme_images_login_logo' ) ) ) : ?>
		<div class="nisje-logo-banner">
			<?php
			printf( '<img class="nisje-logo-banner__logo" src="%s" alt="%s">',
				esc_attr( get_theme_mod( 'nisje_theme_images_login_logo' ) ),
				esc_attr( get_bloginfo( 'name' ) )
			);
			?>
		</div>
	<?php endif; ?>
	<?php if ( ! $has_logo || $has_message ) : ?>
		<div class="nisje-login-header__message">
			<?php
			if ( ! $has_logo ) {
				printf( '<h2 class="nisje-login-header__title">%s</h2>',
					esc_html( get_bloginfo( 'name' ) )
				);
			}

			if ( ! empty( $args['message'] ) ) {
				printf( '<p>%s</p>',
					esc_html( $args['message'] )
				);
			}
			?>
		</div>
	<?php endif; ?>
</header>
