<?php
/**
 * Plugin Name: Nisje - Advanced Search
 * Description: Bring Advanced Search to Nisje
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     1.0.4
 * Text Domain: nisje-advanced-search
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_ADVANCED_SEARCH_VERSION', '1.0.4' );

/**
 * Load plugin textdomain.
 */
function nisje_load_advanced_search_textdomain() {
	load_plugin_textdomain( 'nisje-advanced-search', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_load_advanced_search_textdomain' );

/**
 * Include plugin
 */
function nisje_advanced_search_include() {
	if ( class_exists( '\SearchWP' ) && class_exists( '\calderawp\swp_api\route' ) ) {
		require __DIR__ . '/advanced-search/advanced-search.php';
	}
}
add_action( 'nisje_include', 'nisje_advanced_search_include' );
