<?php
/**
 * Plugin Name: Nisje - Advanced Search
 * Description: Bring Advanced Search to Nisje
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     5.0.6
 * Text Domain: nisje-advanced-search
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\AdvancedSearch;

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_ADVANCED_SEARCH_VERSION', '5.0.6' );

/**
 * Filters
 */
add_action( 'plugins_loaded', __NAMESPACE__ . '\\load_textdomain' );
add_action( 'nisje_register_components', __NAMESPACE__ . '\\register_components' );

/**
 * Load plugin textdomain.
 */
function load_textdomain() {
	load_plugin_textdomain( 'nisje-advanced-search', false, basename( __DIR__ ) . '/languages' );
}

/**
 * Include plugin components
 */
function register_components() {
	if ( class_exists( '\SearchWP' ) && class_exists( '\calderawp\swp_api\route' ) ) {
		require __DIR__ . '/advanced-search/class-advanced-search.php';
		nisje_register_component( new \Dekode\Nisje\Components\Advanced_Search() );
	}
}
