<?php
/**
 * Helper functions.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || exit;

/**
 * Get public Wiki categories
 *
 * @return array $terms
 */
function nisje_get_public_wiki_categories() {
	$taxonomy = 'dekode-wiki-category';
	$terms    = [];

	if ( taxonomy_exists( $taxonomy ) ) {
		$args = [
			'taxonomy' => $taxonomy,
		];

		$terms = get_terms( $args );
	}

	return $terms;
}

/**
 * Get public Wiki categories IDs
 *
 * @return array $ids
 */
function nisje_get_public_wiki_categories_ids() {
	$taxonomy = 'dekode-wiki-category';
	$ids      = [];
	$terms    = [];

	if ( taxonomy_exists( $taxonomy ) ) {
		$args = [
			'taxonomy' => $taxonomy,
		];

		$terms = get_terms( $args );
	}

	if ( $terms ) {
		foreach ( $terms as $term ) {
			array_push( $ids, $term->term_id );
		}
	}

	return $ids;
}
