<?php
/**
 * Plugin Name: Nisje - Drip
 * Description: Extend Drip CRM
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     1.0.0
 * Text Domain: nisje-drip
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_DRIP_VERSION', '1.0.0' );

/**
 * Filters
 */
add_action( 'nisje_include', 'nisje_drip_start' );

/**
 * Start plugin
 */
function nisje_drip_start() {
	if ( function_exists( 'wp_fusion' ) && class_exists( '\\Drip\\Client' ) ) {
		$api_token  = wp_fusion()->settings->get( 'drip_token' );
		$account_id = wp_fusion()->settings->get( 'drip_account' );

		if ( $api_token && $account_id ) {
			// Add custom actions to trigger in Drip.
			return true;
		}
	}
}
