<?php
/**
 * Extend Event Endpoints with Meta Fields
 *
 * @package Nisje
 */

$field_key     = nisje_get_setting( 'field_key', 'event' );
$extend_object = [
	nisje_get_setting( 'post_type_rest_endpoint', 'event' ),
	nisje_get_setting( 'post_type_rest_endpoint_group', 'event' ),
	'feed',
];

// Add start date.
register_rest_field( $extend_object, 'start_date', [
	'get_callback'    => function( $object ) use ( $field_key ) {
		return get_post_meta( $object['id'], $field_key . '_start_date', true );
	},
	'update_callback' => function( $value, $object ) use ( $field_key ) {
		update_post_meta( $object->ID, $field_key . '_start_date', $value );

		return $value;
	},
	'schema'          => [
		'context'     => [ 'view', 'edit' ],
		'description' => esc_html__( 'Start date', 'nisje' ),
		'type'        => 'string',
		'format'      => 'date-time',
		'required'    => true,
	],
] );

// Add end date.
register_rest_field( $extend_object, 'end_date', [
	'get_callback'    => function( $object ) use ( $field_key ) {
		return get_post_meta( $object['id'], $field_key . '_end_date', true );
	},
	'update_callback' => function( $value, $object ) use ( $field_key ) {
		update_post_meta( $object->ID, $field_key . '_end_date', $value );

		return $value;
	},
	'schema'          => [
		'context'     => [ 'view', 'edit' ],
		'description' => esc_html__( 'End date', 'nisje' ),
		'type'        => 'string',
		'format'      => 'date-time',
	],
] );

// Add location.
register_rest_field( $extend_object, 'location', [
	'get_callback'    => function( $object ) use ( $field_key ) {
		return esc_html( get_post_meta( $object['id'], $field_key . '_location_text', true ) );
	},
	'update_callback' => function( $value, $object ) use ( $field_key ) {
		$value = esc_html( $value );
		update_post_meta( $object->ID, $field_key . '_location_text', $value );

		return $value;
	},
	'schema'          => [
		'context'     => [ 'view', 'edit' ],
		'description' => esc_html__( 'Location', 'nisje' ),
		'type'        => 'string',
	],
] );

// Add Attending.
register_rest_field( $extend_object, 'attending', [
	'get_callback' => function( $object ) {
		return nisje_event_get_users_attending( $object['id'] );
	},
	'schema'       => [
		'description' => esc_html__( 'Users ids of users that is attending to this event.', 'nisje' ),
		'type'        => 'array',
		'items'       => [
			'type' => 'integer',
		],
		'readonly'    => true,
	],
] );

// Add Not Attending.
register_rest_field( $extend_object, 'not_attending', [
	'get_callback' => function( $object ) {
		return nisje_event_get_users_not_attending( $object['id'] );
	},
	'schema'       => [
		'description' => esc_html__( 'Users ids of users that is not attending to this event.', 'nisje' ),
		'type'        => 'array',
		'items'       => [
			'type' => 'integer',
		],
		'readonly'    => true,
	],
] );

// Add Maybe Attending.
register_rest_field( $extend_object, 'maybe_attending', [
	'get_callback' => function( $object ) {
		return nisje_event_get_users_maybe_attending( $object['id'] );
	},
	'schema'       => [
		'description' => esc_html__( 'Users ids of users that is maybe attending to this event.', 'nisje' ),
		'type'        => 'array',
		'items'       => [
			'type' => 'integer',
		],
		'readonly'    => true,
	],
] );

// Add Maybe Attending.
register_rest_field( $extend_object, 'invited', [
	'get_callback' => function( $object ) {
		return nisje_event_get_users_invited( $object['id'] );
	},
	'schema'       => [
		'description' => esc_html__( 'Users ids of users that is invited to this event.', 'nisje' ),
		'type'        => 'array',
		'items'       => [
			'type' => 'integer',
		],
		'readonly'    => true,
	],
] );
