<?php
/**
 * Plugin Name: Nisje - Event
 * Description: Add a events to Nisje
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     5.0.5
 * Text Domain: nisje-event
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_EVENT_VERSION', '5.0.5' );

/**
 * Load plugin textdomain.
 */
function nisje_event_load_textdomain() {
	load_plugin_textdomain( 'nisje-event', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_event_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_event_include() {
	require __DIR__ . '/event/event.php';
}
add_action( 'nisje_include', 'nisje_event_include' );
