<?php
/**
 * Plugin Name: Nisje - Main Group
 * Description: Main group functionality
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     1.0.0
 * Text Domain: nisje-main-group
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );

defined( 'ABSPATH' ) || die( 'This is Nisje!' );

define( 'NISJE_MAIN_GROUP_VERSION', '1.0.0' );

/**
 * Load plugin textdomain.
 */
function nisje_main_group_load_textdomain() {
	load_plugin_textdomain( 'nisje-main-group', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_main_group_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_main_group_include() {
	require __DIR__ . '/main-group/main-group.php';
}
add_action( 'nisje_include', 'nisje_main_group_include' );
