<?php
/**
 * Extend Settings Endpoint
 *
 * @package Nisje
 */

declare( strict_types = 1 );

// Add Mandatory Groups.
register_rest_field( 'settings', 'mandatory_groups', [
	'get_callback' => function( array $settings ) : array {
		$groups = nisje_get_setting( 'groups', 'mandatory_groups' );
		if ( is_array( $groups ) && ! empty( $groups ) ) {
			return $groups;
		} else {
			return [];
		}
	},
	'schema'       => [
		'context'     => [ 'view' ],
		'description' => esc_html__( 'Mandatory Groups', 'nisje-mandatory-groups' ),
		'type'        => 'array',
		'items'       => [
			'type' => 'integer',
		],
		'readonly'    => true,
	],
] );
