<?php
/**
 * Updates/Setup/Activation
 *
 * @package Nisje
 */

declare( strict_types=1 );

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Activation.
 */
function nisje_nb_activation() {
	global $wp_roles;

	$all_roles          = nisje_get_setting( 'roles', 'core' );
	$version_option_key = 'nisje_nb_version';

	nisje_activate_roles( $all_roles, nisje_get_setting( 'capability_key', 'nb_applications' ) );
	nisje_activate_roles( $all_roles, nisje_get_setting( 'capability_key', 'nb_reports' ) );
	nisje_activate_roles( $all_roles, nisje_get_setting( 'capability_key', 'nb_annual_reports' ) );

	if ( class_exists( 'WP_Roles' ) && ! isset( $wp_roles ) ) {
		$wp_roles = new WP_Roles(); // phpcs:ignore
	}

	if ( is_object( $wp_roles ) ) {
		$admin_roles = [
			'administrator',
			'editor',
			'nisje_api_user',
		];

		foreach ( (array) $admin_roles as $role_object ) {
			$r = get_role( $role_object );
			if ( $r ) {
				$r->add_cap( 'nisje_nb_application_dashboard' );
				$r->add_cap( 'nisje_nb_ar_dashboard' );
				$r->add_cap( 'nisje_nb_ar_dashboard_show_all' );
			}
		}

		$subscriber = $wp_roles->get_role( 'subscriber' );

		add_role(
			'nisje_nb_ar_user',
			esc_html__( 'NB Annul Report User', 'nisje-nb' ),
			$subscriber->capabilities
		);

		nisje_activate_roles( [ 'nisje_nb_ar_user' ], nisje_get_setting( 'capability_key', 'nb_annual_reports' ) );

		add_role(
			'nisje_nb_ar_user_light',
			esc_html__( 'NB Annul Report Light User', 'nisje-nb' ),
			$subscriber->capabilities
		);

		nisje_activate_roles( [ 'nisje_nb_ar_user_light' ], nisje_get_setting( 'capability_key', 'nb_annual_reports' ) );

		add_role(
			'nisje_nb_ar_user_countycouncil',
			esc_html__( 'NB Annul Report County Council User', 'nisje-nb' ),
			$subscriber->capabilities
		);

		nisje_activate_roles( [ 'nisje_nb_ar_user_countycouncil' ], nisje_get_setting( 'capability_key', 'nb_annual_reports' ) );
	}

	update_option( $version_option_key, NISJE_NB_VERSION );
}
