<?php
/**
 * Setup News Tag
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$cap            = nisje_get_setting( 'capability_key', 'news' );
$taxonomy_tag   = nisje_get_setting( 'taxonomy_tag', 'news' );
$post_type_name = nisje_get_setting( 'post_type_name', 'news' );

$args = apply_filters(
	'nisje_news_taxonomy_tag_args', [
		'labels'                => [
			'name'          => esc_html_x( 'Tags', 'taxonomy general name', 'nisje-news' ),
			'singular_name' => esc_html_x( 'Tags', 'taxonomy singular name', 'nisje-news' ),
			'menu_name'     => esc_html__( 'Tags', 'nisje-news' ),
		],
		'hierarchical'          => false,
		'show_admin_column'     => true,
		'show_ui'               => true,
		'query_var'             => true,
		'rewrite'               => false,
		'capability_type'       => $cap,
		'capabilities'          => [],
		'show_in_rest'          => true,
		'rest_base'             => $taxonomy_tag['rest_endpoint'],
		'rest_controller_class' => 'WP_REST_Terms_Controller',
	]
);

$object_type = apply_filters( 'nisje_news_taxonomy_tag_object_types', [ $post_type_name ] );

register_taxonomy( $taxonomy_tag['name'], $object_type, $args );
