<?php
/**
 * Plugin Name: Nisje - News
 * Description: Add a news to Nisje
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     1.0.0
 * Text Domain: nisje-news
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_NEWS_VERSION', '1.0.0' );

/**
 * Load plugin textdomain.
 */
function nisje_news_load_textdomain() {
	load_plugin_textdomain( 'nisje-news', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_news_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_news_include() {
	require __DIR__ . '/news/news.php';
}
add_action( 'nisje_include', 'nisje_news_include' );
