<?php
/**
 * Reactions
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Reactions;

defined( 'ABSPATH' ) || die( 'This is Nisje!' );

/**
 * Filters
 */
add_filter( 'nisje_notification_enrich_data', __NAMESPACE__ . '\\enrich_notification_data', 10, 3 );

// Notifications.
add_action( 'nisje_add_reaction', __NAMESPACE__ . '\\reaction_notification', 10, 4 );

/**
 * Populate Notifications
 *
 * @param array  $args         Arguments.
 * @param string $action       Action.
 * @param array  $notification Arguments.
 */
function enrich_notification_data( array $args, string $action, array $notification ) : array {
	if ( in_array( $action, [ 'post_reaction', 'comment_reaction' ], true ) ) {
		$args['item_id'] = bp_core_get_user_displayname( $notification['item_id'] );

		$post = get_post( $notification['secondary_item_id'] );
		if ( $post instanceof \WP_Post ) {
			$args['secondary_item_id'] = wp_strip_all_tags( get_the_title( $post->ID ) );
			$args['href']              = \Nisje\Nofications\get_post_url( $post );
		}

		$args['avatar'] = $notification['item_id'];

		if ( 'post_reaction' === $action ) {
			$args['message'] = [
				'raw'      => '%1$s reacted to your post "%2$s"',
				// translators: %1$s name of the user reaction, %2$s the post.
				'rendered' => sprintf( esc_html__( '%1$s reacted to your post %2$s', 'nisje' ),
					'<strong>' . $args['item_id'] . '</strong>',
					'<strong>' . $args['secondary_item_id'] . '</strong>'
				),
			];
		} else {
			$args['message'] = [
				'raw'      => '%1$s reacted to your comment on the post "%2$s"',
				// translators: %1$s name of the user reaction, %2$s the post.
				'rendered' => sprintf( esc_html__( '%1$s reacted to your comment on the post %2$s', 'nisje' ),
					'<strong>' . $args['item_id'] . '</strong>',
					'<strong>' . $args['secondary_item_id'] . '</strong>'
				),
			];
		}
	}

	return $args;
}

/**
 * Register reaction notification
 *
 * @param int    $object_id Object ID.
 * @param int    $user_id User ID.
 * @param string $object_type Object Type.
 * @param string $reaction_type_id Reaction type ID.
 *
 * @return void
 */
function reaction_notification( $object_id, $user_id, $object_type, $reaction_type_id ) {
	if ( 'comment' === $object_type ) {
		$comment = get_comment( $object_id );

		if ( $comment && ( intval( $user_id ) !== intval( $comment->user_id ) ) ) {
			$post = get_post( $comment->comment_post_ID );

			bp_notifications_add_notification( [
				'user_id'           => $comment->user_id,
				'item_id'           => $user_id,
				'secondary_item_id' => $post->ID,
				'component_name'    => 'nisje',
				'component_action'  => 'comment_reaction',
				'date_notified'     => bp_core_current_time(),
				'is_new'            => 1,
			] );
		}
	} else {
		$post = get_post( $object_id );

		if ( get_current_user_id() !== intval( $post->post_author ) ) {
			bp_notifications_add_notification( [
				'user_id'           => $post->post_author,
				'item_id'           => $user_id,
				'secondary_item_id' => $post->ID,
				'component_name'    => 'nisje',
				'component_action'  => 'post_reaction',
				'date_notified'     => bp_core_current_time(),
				'is_new'            => 1,
			] );
		}
	}
}
