<?php
/**
 * Mail
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Resets;

/**
 * Setup mail details
 */
function mail_setup() {
	add_filter( 'wp_mail_from', __NAMESPACE__ . '\mail_from' );
	add_filter( 'wp_mail_from_name', __NAMESPACE__ . '\mail_from_name' );
	add_action( 'phpmailer_init', __NAMESPACE__ . '\mail_return_path' );
	add_action( 'bp_before_email_footer', __NAMESPACE__ . '\\remove_unsubscribe_link' );
	add_action( 'bp_email_get_link', __NAMESPACE__ . '\unsubscribe_link', 10, 3 );
}
add_action( 'init', __NAMESPACE__ . '\mail_setup' );

/**
 * Setup mail from
 *
 * @param string $from Mail from.
 * @return string Optimized Mail from.
 */
function mail_from( $from ) {
	$from = nisje_get_setting( 'mail_from', 'general' );
	if ( ! empty( $from ) ) {
		return $from;
	} else {
		return 'noreply@nisje.io';
	}
}

/**
 * Setup mail from name
 *
 * @param string $from_name Mail from name.
 * @return string Optimized Mail from name.
 */
function mail_from_name( $from_name ) {
	$from_name = nisje_get_setting( 'mail_from_name', 'general' );
	if ( ! empty( $from_name ) ) {
		return $from_name;
	} else {
		return 'Nisje';
	}
}

/**
 * Setup mail return path
 *
 * @param object $phpmailer PHPMailer object.
 */
function mail_return_path( $phpmailer ) {
	$phpmailer->Sender = $phpmailer->From; // phpcs:ignore
}

/**
 * Remove unsubscribe link.
 */
function remove_unsubscribe_link() {
	?>
	<style>
	.footer_bg a {
		display: none;
	}
	</style>
	<?php
}
/**
 * Unsubscribe link
 *
 * @param string $link        Link.
 * @param string $redirect_to Redirect to.
 * @param array  $args        Arguments.
 *
 * @return string $link Link.
 */
function unsubscribe_link( $link, $redirect_to, $args ) {
	if ( isset( $args['user_id'] ) ) {
		return esc_url( home_url( 'account/notifications' ) );
	}

	return esc_url( home_url() );
}
