<?php
/**
 * Extend Settings Endpoint with safe image URL
 *
 * @package Nisje
 */

register_rest_field( 'settings', 'scraper_api_url', [
	'get_callback' => function( $object ) {
		return nisje_get_dir( 'static-api/safe-image.php' );
	},
	'schema'       => [
		'description' => esc_html__( 'URL for the safe image API', 'nisje' ),
		'type'        => 'string',
		'format'      => 'uri',
		'readonly'    => true,
	],
] );
