<?php
/**
 * Extend Cards with Profile Fields
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

register_rest_field( 'user-content', 'profile_layouts', [
	'get_callback' => function( $object ) {
		$retval = [];

		$retval = [
			'di_member_listing_header_fields' => nisje_get_user_profile_layouts( $object['user_id'], 'di_member_listing_header_fields' ),
		];

		return $retval;
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => esc_html__( 'Collection of profile fields', 'nisje' ),
		'type'        => 'array',
		'items'       => [
			'type' => 'object',
		],
		'readonly'    => true,
	],
] );
