<?php
/**
 * Returns
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Resets;

/**
 * Setup default hook returns.
 */
function returns() {
	if ( ! is_admin() ) {
		// Remove AdminBar frontend.
		// phpcs:disable WordPress.VIP.AdminBarRemoval.RemovalDetected
		add_filter( 'show_admin_bar', '__return_false' );
		// phpcs:enable

		// Disable default BuddyPress style.
		add_action( 'bp_core_register_common_styles', '__return_empty_array', 100 );
	}

	// Allow BuddyPress to work properly even if public is set to false.
	add_filter( 'bbp_is_site_public', '__return_true' );

	// Do not show title headings.
	add_filter( 'bp_get_directory_title', '__return_empty_string' );

	add_filter( 'bp_ignore_deprecated', '__return_true' );
	add_filter( 'bp_core_fetch_avatar_no_grav', '__return_false' );
}
add_action( 'init', __NAMESPACE__ . '\returns' );
