<?php
/**
 * Extend Settings Endpoint
 *
 * @package Nisje
 */

// Register font.
register_rest_field( 'settings', 'font', [
	'get_callback' => function( $object, $field, $request ) {
		$prepend_key = nisje_get_setting( 'prepend_key', 'customizer' );

		return get_theme_mod( $prepend_key . 'font', 'circular' );
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => esc_html__( 'Font.', 'nisje' ),
		'type'        => 'string',
		'items'       => [
			'type' => 'string',
		],
		'readonly'    => true,
	],
] );
