<?php
/**
 * Gettext changes.
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Resets;

/**
 * Filters
 */
add_filter( 'gettext', __NAMESPACE__ . '\switch_translation_strings', 20, 3 );
add_action( 'current_screen', __NAMESPACE__ . '\current_screen' );
add_filter( 'bp_email_get_salutation', __NAMESPACE__ . '\\optimize_salutation', 10, 3 );

/**
 * Switch translation strings.
 *
 * @param string $translated_text Text as translated.
 * @param string $text            Text untranslated.
 * @param string $domain          Text domain.
 *
 * @return string Translated string.
 */
function switch_translation_strings( $translated_text, $text, $domain ) {
	switch ( $translated_text ) {
		// Norwegian translation.
		case 'Tilbakestill passord':
			$translated_text = esc_html__( 'Lagre nytt passord', 'nisje' );
			break;
	}

	return $translated_text;
}


/**
 * Example of current_screen usage
 *
 * @param \WP_Screen $current_screen Current screen.
 */
function current_screen( $current_screen ) {
	if ( 'users' === $current_screen->base ) {
		add_filter( 'gettext', __NAMESPACE__ . '\switch_translation_spam_strings', 20, 3 );
	}
}

/**
 * Switch translation spam vs inactive strings.
 *
 * @param string $translated_text Text as translated.
 * @param string $text            Text untranslated.
 * @param string $domain          Text domain.
 *
 * @return string Translated string.
 */
function switch_translation_spam_strings( $translated_text, $text, $domain ) {
	switch ( $translated_text ) {
		case 'Spam':
			$translated_text = esc_html__( 'Deactivate', 'nisje' );
			break;
		case 'Not Spam':
			$translated_text = esc_html__( 'Reactivate', 'nisje' );
			break;
		case 'User marked as spammer. Spam users are visible only to site admins.':
			$translated_text = esc_html__( 'User marked as inactive. Inactive users are visible only to site admins.', 'nisje' );
			break;
		case 'User removed from spam.':
			$translated_text = esc_html__( 'User reactivated.', 'nisje' );
			break;
		case 'Bruker fjernet fra søppelpost':
			$translated_text = esc_html__( 'Brukeren er nå reaktivert', 'nisje' );
			break;
		case 'Uønsket':
			$translated_text = esc_html__( 'Deaktivere bruker', 'nisje' );
			break;
		case 'Ikke uønsket':
			$translated_text = esc_html__( 'Aktivere bruker', 'nisje' );
			break;
	}

	return $translated_text;
}

/**
 * Filter The Recipient Salutation inside the Email Template.
 *
 * @param string $salutation The Salutation.
 * @param array  $settings   Email Settings.
 * @param string $token      The token.

 * @return string The optimized salutation.
 */
function optimize_salutation( string $salutation, array $settings, string $token ) : string {
	return sprintf(
		// translators: %s The Recipient Salutation.
		esc_html_x( 'Hi %s', 'recipient salutation', 'nisje' ),
		$token
	);
}
