<?php
/**
 * Setup Group Types Component
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Components;

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Group Types Component Class
 */
class Group_Types extends Component {
	/**
	 * Constructor
	 */
	public function __construct() {
		$path = trailingslashit( dirname( __FILE__ ) );

		parent::start(
			'group-types',
			esc_html__( 'Group Types', 'nisje' ),
			$path,
			'group_types',
			'dekode_intranet_settings_group_types'
		);
	}

	/**
	 * Global variables
	 */
	public function setup_globals() {
		$settings = get_option( $this->option_key );
		if ( is_array( $settings ) && ! empty( $settings ) ) {
			foreach ( $settings as $key => $value ) {
				$this->settings[ $key ] = $value;
			}
		}
	}

	/**
	 * Setup Filters
	 */
	public function setup_filters() {
		// Register BuddyPress group types.
		add_action( 'bp_groups_register_group_types', [ $this, 'register_group_types' ] );

		if ( is_admin() ) {
			add_action( 'nisje_settings_register_field_groups', [ $this, 'register_field_group' ] );
			add_action( 'nisje_settings_add_option_page', [ $this, 'setup_settings_menu' ] );
			add_action( 'nisje_settings_populate_options_from_acf', [ $this, 'populate_acf_settings' ] );
		}
	}

	/**
	 * Register REST Endpoints
	 */
	public function register_rest_routes() {
		nisje_include( 'includes/components/group-types/rest-handlers/extend-settings.php' );
	}

	/**
	 * Register REST Endpoints
	 */
	public function register_group_types() {
		$group_types = nisje_get_setting( 'group_types' );

		$group_types = apply_filters( 'nisje_register_group_types', $group_types );

		if ( ! empty( $group_types ) && is_array( $group_types ) ) {
			foreach ( $group_types as $group_key => $args ) {
				if ( ! empty( $group_key ) && is_array( $args ) && ! empty( $args ) ) {
					bp_groups_register_group_type( $group_key, $args );
				}
			}
		}
	}

	/**
	 * Setup options field group.
	 */
	public function register_field_group() {
		nisje_include( 'includes/components/group-types/acf/field-groups/acf-field-group-options-group-types.php' );
	}

	/**
	 * Setup settings menu.
	 */
	public function setup_settings_menu() {
		acf_add_options_sub_page( [
			'page_title'  => esc_html__( 'Group Types', 'nisje' ),
			'menu_title'  => esc_html__( 'Group Types', 'nisje' ),
			'capability'  => nisje_get_setting( 'settings_cap', 'core' ),
			'menu_slug'   => 'nisje-settings-group-types',
			'parent_slug' => nisje_get_setting( 'settings_key', 'core' ),
		] );
	}

	/**
	 * Populate ACF Options Group Types
	 *
	 * @param WP_Screen $screen Screen object.
	 */
	public function populate_acf_settings( $screen ) {
		if ( false !== strpos( $screen->id, 'nisje-settings-group-types' ) ) {
			$group_types = [];

			$types = get_field( 'dekode_intranet_group_types', 'option' );
			if ( ! empty( $types ) ) {
				foreach ( $types as $type ) {
					$key            = '';
					$name           = '';
					$singular_name  = '';
					$directory_slug = false;
					$description    = '';

					if ( isset( $type['dekode_intranet_group_types_key'] ) && ! empty( $type['dekode_intranet_group_types_key'] ) ) {
						$key = sanitize_key( $type['dekode_intranet_group_types_key'] );
					}

					if ( isset( $type['dekode_intranet_group_types_name'] ) && ! empty( $type['dekode_intranet_group_types_name'] ) ) {
						$name = esc_html( $type['dekode_intranet_group_types_name'] );
					}

					if ( isset( $type['dekode_intranet_group_types_singular_name'] ) && ! empty( $type['dekode_intranet_group_types_singular_name'] ) ) {
						$singular_name = esc_html( $type['dekode_intranet_group_types_singular_name'] );
					}

					if ( isset( $type['dekode_intranet_group_types_description'] ) && ! empty( $type['dekode_intranet_group_types_description'] ) ) {
						$description = esc_html( $type['dekode_intranet_group_types_description'] );
					}

					if ( isset( $type['dekode_intranet_group_types_has_directory'] ) && $type['dekode_intranet_group_types_has_directory'] ) {
						if ( isset( $type['dekode_intranet_group_types_directory_slug'] ) && ! empty( $type['dekode_intranet_group_types_directory_slug'] ) ) {
							$directory_slug = sanitize_key( $type['dekode_intranet_group_types_directory_slug'] );
						}
					}

					if ( $key && $name && $singular_name ) {
						$group_types[ $key ] = [
							'key'                   => $key,
							'labels'                => [
								'name'          => $name,
								'singular_name' => $singular_name,
							],
							'directory_slug'        => $directory_slug,
							'has_directory'         => $directory_slug,
							'show_in_create_screen' => ( isset( $type['dekode_intranet_group_types_show_in_create_screen'] ) && $type['dekode_intranet_group_types_show_in_create_screen'] ) ? true : false,
							'show_in_list'          => ( isset( $type['dekode_intranet_group_types_show_in_list'] ) && $type['dekode_intranet_group_types_show_in_list'] ) ? true : false,
							'exclude_groups'        => ( isset( $type['dekode_intranet_group_types_exclude_groups_from_listing'] ) && $type['dekode_intranet_group_types_exclude_groups_from_listing'] ) ? true : false,
							'create_screen_checked' => false,
							'description'           => $description,
						];
					}
				}
			}

			update_option( 'dekode_intranet_settings_group_types', $group_types );
		}
	}
}
