<?php
/**
 * Setup Map Group Types Taxonomy
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$taxonomy_args = [
	'labels'            => [
		'name'          => esc_html_x( 'Map Group Types', 'taxonomy general name', 'nisje' ),
		'singular_name' => esc_html_x( 'Map Group Type', 'taxonomy singular name', 'nisje' ),
	],
	'hierarchical'      => false,
	'show_admin_column' => false,
	'show_ui'           => false,
	'query_var'         => false,
	'rewrite'           => false,
	'show_in_rest'      => false,
];

/**
 * Filters the taxonomy arguments for this taxonomy.
 *
 * @param array $taxonomy_args Taxonomy arguments.
 */
$taxonomy_args = apply_filters( 'nisje_taxonomy_map_group_types_args', $taxonomy_args );

/**
 * Filters the object types to connect to this taxonomy.
 *
 * @param array Post type arguments.
 */
$object_types = apply_filters( 'nisje_taxonomy_map_group_types_object_types', [ 'post', 'page' ] );

register_taxonomy( 'nisje-map-group-types', $object_types, $taxonomy_args );
