<?php
/**
 * Extend Settings Endpoint with Mail Notifications.
 *
 * @package Nisje
 */

register_rest_field(
	'settings', 'mail_notifications', [
		'get_callback' => function( $object ) {
			return nisje_get_setting( 'mail_notification' );
		},
		'schema'       => [
			'context'     => [ 'view', 'edit' ],
			'description' => esc_html__( 'Notification settings.', 'nisje' ),
			'type'        => 'array',
			'items'       => [
				'type' => 'string',
			],
			'readonly'    => true,
		],
	]
);
