<?php
/**
 * User
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\User;

defined( 'ABSPATH' ) || die( 'This is Nisje!' );

/**
 * Filters
 */
add_action( 'rest_api_init', __NAMESPACE__ . '\\register_api_init' );

/**
 * Extend with custom rest fields.
 *
 * @return void
 */
function register_api_init() {
	// Last activity.
	register_rest_field( 'user', 'last_activity', [
		'get_callback' => function( $object ) {
			return nisje_prepare_date_response( bp_get_user_last_activity( $object['id'] ) );
		},
		'schema'       => [
			'context'     => [ 'view', 'edit' ],
			'description' => esc_html__( 'Last activity in group', 'nisje' ),
			'type'        => 'string',
			'format'      => 'date-time',
			'readonly'    => true,
		],
	] );

	register_rest_field( 'user', 'notifications_unseen', [
		'update_callback' => function( $value, $object, $field_name, $request, $object_type ) {
			update_user_meta( $object->ID, 'notifications_unseen', (int) $value );
		},
		'schema'          => [
			'context'     => [ 'edit' ],
			'description' => esc_html__( 'Unseen notifications', 'nisje' ),
			'type'        => 'integer',
		],
	] );
}
