<?php
/**
 * Assets
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Resets;

/**
 * De-register BP Scripts.
 *
 * @param array $scripts Array of scripts.
 * @return array Optimized array of scripts.
 */
function deregister_bp_scripts( $scripts ) {
	if ( ! is_admin() && ! bp_is_register_page() ) {
		unset( $scripts['bp-jquery-scroll-to'] );
		unset( $scripts['bp-widget-members'] );
		unset( $scripts['bp-jquery-query'] );
	}

	return $scripts;
}
add_action( 'bp_core_register_common_scripts', __NAMESPACE__ . '\deregister_bp_scripts', 100 );
