<?php
/**
 * Mail Notifications Component
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Components;

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Mail Notifications Component Class
 */
class Mail_Notifications extends Component {
	/**
	 * Constructor
	 */
	public function __construct() {
		$path = trailingslashit( dirname( __FILE__ ) );

		parent::start(
			'mail-notification',
			esc_html__( 'Mail Notifications', 'nisje' ),
			$path
		);
	}

	/**
	 * Setup globals
	 */
	public function setup_globals() {
		$defaults = [
			'general' => [
				'label'         => esc_html__( 'General', 'nisje' ),
				'notifications' => [
					[
						'key'         => 'notification_new_mention',
						'label'       => esc_html__( 'A member mentions you in an update', 'nisje' ),
						'description' => '',
					],
					[
						'key'         => 'notification_new_comment',
						'label'       => esc_html__( 'A member has replied to an activity update that the recipient posted.', 'nisje' ),
						'description' => '',
					],
				],
			],
			'groups'  => [
				'label'         => esc_html__( 'Groups', 'nisje' ),
				'notifications' => [
					[
						'key'         => 'notification_groups_invite',
						'label'       => esc_html_x( 'A member invites you to join a group', 'group settings on notification settings page', 'nisje' ),
						'description' => '',
					],
					[
						'key'         => 'notification_groups_group_updated',
						'label'       => esc_html_x( 'Group information is updated', 'group settings on notification settings page', 'nisje' ),
						'description' => '',
					],
					[
						'key'         => 'notification_groups_admin_promotion',
						'label'       => esc_html_x( 'You are promoted to a group administrator or moderator', 'group settings on notification settings page', 'nisje' ),
						'description' => '',
					],
					[
						'key'         => 'notification_groups_membership_request',
						'label'       => esc_html_x( 'Your request to join a group has been approved or denied', 'group settings on notification settings page', 'nisje' ),
						'description' => '',
					],
				],
			],
		];

		$this->settings = array_merge( $defaults, (array) $this->settings );
	}

	/**
	 * Setup actions
	 */
	public function setup_filters() {
		add_action( 'nisje_components_registered', [ $this, 'setup_notifications' ] );
		add_action( 'nisje_register_content_types', [ $this, 'register_default_notifications' ] );
	}

	/**
	 * Register REST Endpoints
	 */
	public function register_rest_routes() {
		$this->include_file( 'rest-handlers/extend-settings.php' );
	}

	/**
	 * Register REST Endpoints
	 */
	public function setup_notifications() {
		if ( function_exists( 'bp_send_email' ) ) {
			/*
			Needs some more testing.
			$this->include_file( 'notifications.php' );
			*/
			return;
		}
	}

	/**
	 * Register defaults.
	 */
	public function register_default_notifications() {
		$notification_groups = nisje_get_setting( 'mail_notification' );

		$args = [
			'sanitize_callback' => [ $this, 'sanitize_meta' ],
			'auth_callback'     => [ $this, 'authorize_meta' ],
			'type'              => 'string',
			'description'       => '',
			'single'            => true,
			'show_in_rest'      => [
				'schema' => [
					'context' => [ 'edit' ],
				],
			],
		];

		foreach ( (array) $notification_groups as $group ) {
			if ( isset( $group['notifications'] ) ) {
				foreach ( (array) $group['notifications'] as $notification ) {
					$args['description'] = $notification['label'];

					register_meta( 'user', $notification['key'], $args );
				}
			}
		}
	}

	/**
	 * Sanitize Meta
	 *
	 * @param string $meta_value Meta value.
	 * @param string $meta_key   Meta key.
	 * @param string $meta_type  Meta type.
	 *
	 * @return string Sanitized meta value
	 */
	public function sanitize_meta( $meta_value, $meta_key, $meta_type ) {
		if ( ! in_array( $meta_value, [ 'yes', 'no' ], true ) ) {
			$meta_value = 'no';
		}

		return $meta_value;
	}

	/**
	 * Authorize Meta
	 *
	 * @param bool   $allowed  User allowed to view this value.
	 * @param string $meta_key Meta key.
	 * @param int    $post_id  Post ID.
	 * @param int    $user_id  User ID.
	 * @param string $cap      Capability.
	 * @param array  $caps     Capabilities.
	 *
	 * @return bool True if user is allowed to view this value
	 */
	public function authorize_meta( $allowed, $meta_key, $post_id, $user_id, $cap, $caps ) {
		if ( bp_loggedin_user_id() !== $user_id ) {
			$allowed = false;
		} else {
			$allowed = true;
		}

		return $allowed;
	}
}
