<?php
/**
 * E-mail notifications
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\EmailNofications;

defined( 'ABSPATH' ) || die( 'This is Nisje!' );

/**
 * Filters
 */
add_filter( 'nisje_register_notification_types', __NAMESPACE__ . '\\register_notifications', 100 );

/**
 * Register notifications.
 *
 * @param array $notifications Registered notifications.
 * @return array
 */
function register_notifications( array $notifications ) : array {
	$notifications[] = [
		'key'         => 'notification_groups_invite',
		'label'       => esc_html_x( 'A member invites you to join a group', 'group settings on notification settings page', 'nisje' ),
		'description' => esc_html__( 'E-mail notification', 'nisje' ),
		'type'        => 'email',
		'is_core_bp'  => true,
	];

	$notifications[] = [
		'key'         => 'notification_groups_group_updated',
		'label'       => esc_html_x( 'Group information is updated', 'group settings on notification settings page', 'nisje' ),
		'description' => esc_html__( 'E-mail notification', 'nisje' ),
		'type'        => 'email',
		'is_core_bp'  => true,
	];

	$notifications[] = [
		'key'         => 'notification_groups_admin_promotion',
		'label'       => esc_html_x( 'You are promoted to a group administrator or moderator', 'group settings on notification settings page', 'nisje' ),
		'description' => esc_html__( 'E-mail notification', 'nisje' ),
		'type'        => 'email',
		'is_core_bp'  => true,
	];

	$notifications[] = [
		'key'         => 'notification_groups_membership_request',
		'label'       => esc_html_x( 'Your request to join a group has been approved or denied', 'group settings on notification settings page', 'nisje' ),
		'description' => esc_html__( 'E-mail notification', 'nisje' ),
		'type'        => 'email',
		'is_core_bp'  => true,
	];

	$notifications[] = [
		'key'         => 'notification_membership_request_completed',
		'label'       => esc_html_x( 'Your request to join a group has been completed', 'group settings on notification settings page', 'nisje' ),
		'description' => esc_html__( 'E-mail notification', 'nisje' ),
		'type'        => 'email',
		'is_core_bp'  => true,
	];

	return $notifications;
}
