<?php
/**
 * Extend User Endpoint
 *
 * @package Nisje
 */

// Add member types for user.
register_rest_field( 'user', 'member_types', [
	'get_callback' => function( $object ) {
		$retval = [];

		$member_types = bp_get_member_type( $object['id'], false );
		if ( $member_types ) {
			$retval = $member_types;
		}

		return $retval;
	},
	'schema'       => [
		'context'     => [ 'edit' ],
		'description' => esc_html__( 'Users member types.', 'nisje' ),
		'type'        => 'array',
		'items'       => [
			'type' => 'string',
		],
		'readonly'    => true,
	],
] );
