<?php
/**
 * Setup Groups Component
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Components;

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Groups Component Class
 */
class Groups extends Component {
	/**
	 * Constructor
	 */
	public function __construct() {
		parent::start(
			'groups',
			__( 'Groups', 'nisje' )
		);
	}

	/**
	 * Register REST Endpoints
	 */
	public function register_rest_routes() {
		nisje_include( 'includes/components/groups/rest-handlers/class-groups-controller.php' );
		$controller = new \Dekode\Nisje\Components\Rest\Groups_Controller();
		$controller->register_routes();

		nisje_include( 'includes/components/groups/rest-handlers/class-groups-members-controller.php' );
		$controller = new \Dekode\Nisje\Components\Rest\Groups_Members_Controller();
		$controller->register_routes();

		nisje_include( 'includes/components/groups/rest-handlers/class-groups-memberships-controller.php' );
		$controller = new \Dekode\Nisje\Components\Rest\Groups_Memberships_Controller();
		$controller->register_routes();

		nisje_include( 'includes/components/groups/rest-handlers/class-groups-invites-controller.php' );
		$controller = new \Dekode\Nisje\Components\Rest\Groups_Invites_Controller();
		$controller->register_routes();
	}
}
