<?php
/**
 * Setup Associated taxonomy.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$args = apply_filters( 'nisje_taxonomy_associated_args', [
	'labels'            => [
		'name'          => esc_html_x( 'Associated items', 'taxonomy general name', 'nisje' ),
		'singular_name' => esc_html_x( 'Associated item', 'taxonomy singular name', 'nisje' ),
	],
	'hierarchical'      => false,
	'show_admin_column' => false,
	'show_ui'           => false,
	'query_var'         => false,
	'rewrite'           => false,
	'show_in_rest'      => false,
] );

$object_type = apply_filters( 'nisje_taxonomy_associated_object_types', [ 'post', 'page' ] );

register_taxonomy( 'nisje-associated', $object_type, $args );
