<?php
/**
 * Helper functions.
 *
 * @package Nisje
 */

/**
 * Add customizer functionality.
 *
 * @param WP_Customize_Manager $wp_customize Customizer object.
 * @param array                $args         Arguments.
 *
 * @return WP_Customize_Manager $wp_customize Customizer object.
 */
function nisje_customizer_add_setting( $wp_customize, $args ) {
	if ( $wp_customize instanceof \WP_Customize_Manager && is_array( $args ) ) {

		$default = [];

		if ( isset( $args['nisje_default'] ) ) {
			$default = [
				'default' => $args['nisje_default'],
			];
		}

		$wp_customize->add_setting( $args['settings'], $default );
		$wp_customize->add_control( $args['settings'] . '_control', $args );
	}

	return $wp_customize;
}
