<?php
/**
 * Extend User Endpoint
 *
 * @package Nisje
 */

// Add avatar URLs.
register_rest_field( 'user', 'avatar_urls', [
	'get_callback' => function( $object ) {
		return nisje_get_user_avatar( $object['id'] );
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => esc_html__( 'Avatar URLs for the resource', 'nisje' ),
		'type'        => 'object',
		'properties'  => nisje_get_avatar_rest_properties(),
		'readonly'    => true,
	],
] );
