<?php
/**
 * ACF Group Settings: Group Types.
 *
 * @TODO: Move this to settings API.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

acf_add_local_field_group(
	[
		'key'                   => 'dekode_intranet_group_option_group_types',
		'title'                 => esc_html__( 'Group Types', 'nisje' ),
		'fields'                => [
			[
				'key'          => 'dekode_intranet_key_group_types',
				'label'        => esc_html__( 'Register Group Types', 'nisje' ),
				'name'         => 'dekode_intranet_group_types',
				'type'         => 'repeater',
				'layout'       => 'block',
				'button_label' => esc_html__( 'Add group type', 'nisje' ),
				'sub_fields'   => [
					[
						'key'         => 'dekode_intranet_key_group_types_key',
						'label'       => esc_html__( 'Key', 'nisje' ),
						'name'        => 'dekode_intranet_group_types_key',
						'type'        => 'text',
						'wrapper'     => [
							'width' => '33',
						],
						'placeholder' => esc_html__( 'Ex: student', 'nisje' ),
					],
					[
						'key'     => 'dekode_intranet_key_group_types_name',
						'label'   => esc_html__( 'Name', 'nisje' ),
						'name'    => 'dekode_intranet_group_types_name',
						'type'    => 'text',
						'wrapper' => [
							'width' => '33',
						],
					],
					[
						'key'     => 'dekode_intranet_key_group_types_singular_name',
						'label'   => esc_html__( 'Singular Name', 'nisje' ),
						'name'    => 'dekode_intranet_group_types_singular_name',
						'type'    => 'text',
						'wrapper' => [
							'width' => '33',
						],
					],
					[
						'key'           => 'dekode_intranet_key_group_types_has_directory',
						'label'         => esc_html__( 'Has directory?', 'nisje' ),
						'name'          => 'dekode_intranet_group_types_has_directory',
						'type'          => 'true_false',
						'wrapper'       => [
							'width' => '33',
						],
						'default_value' => 1,
					],
					[
						'key'               => 'dekode_intranet_key_group_types_directory_slug',
						'label'             => esc_html__( 'Directory slug', 'nisje' ),
						'name'              => 'dekode_intranet_group_types_directory_slug',
						'type'              => 'text',
						'conditional_logic' => [
							[
								[
									'field'    => 'dekode_intranet_key_group_types_has_directory',
									'operator' => '==',
									'value'    => '1',
								],
							],
						],
						'wrapper'           => [
							'width' => '67',
						],
					],
					[
						'key'          => 'dekode_intranet_key_group_types_show_in_create_screen',
						'label'        => esc_html__( 'Show in create screen?', 'nisje' ),
						'name'         => 'dekode_intranet_group_types_show_in_create_screen',
						'type'         => 'true_false',
						'instructions' => esc_html__( 'If set to true, the group type will be selectable during group creation and when a group administrator is on the group’s “Manage > Settings” page.', 'nisje' ),
						'wrapper'      => [
							'width' => '33',
						],
					],
					[
						'key'          => 'dekode_intranet_key_group_types_show_in_list',
						'label'        => esc_html__( 'Show in list?', 'nisje' ),
						'name'         => 'dekode_intranet_group_types_show_in_list',
						'type'         => 'true_false',
						'instructions' => esc_html__( 'If set to true, the group type will be shown in the dropdown list when filtering on group types.', 'nisje' ),
						'wrapper'      => [
							'width' => '33',
						],
					],
					[
						'key'          => 'dekode_intranet_key_group_types_exclude_groups_from_listing',
						'label'        => esc_html__( 'Exclude groups with this group type from group listings', 'nisje' ),
						'name'         => 'dekode_intranet_group_types_exclude_groups_from_listing',
						'type'         => 'true_false',
						'instructions' => esc_html__( 'If set to true, the groups with connected to this group type will be excluded on the groups archive page.', 'nisje' ),
						'wrapper'      => [
							'width' => '33',
						],
					],
				],
			],
		],
		'location'              => [
			[
				[
					'param'    => 'options_page',
					'operator' => '==',
					'value'    => 'nisje-settings-group-types',
				],
			],
		],
		'menu_order'            => 0,
		'position'              => 'normal',
		'style'                 => 'default',
		'label_placement'       => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen'        => '',
		'active'                => 1,
		'description'           => '',
	]
);
