<?php
/**
 * Setup Tags Taxonomy
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$taxonomy_args = [
	'labels'                => [
		'name'          => esc_html_x( 'Tags', 'taxonomy general name', 'nisje' ),
		'singular_name' => esc_html_x( 'Tag', 'taxonomy singular name', 'nisje' ),
	],
	'hierarchical'          => false,
	'show_admin_column'     => true,
	'show_ui'               => true,
	'query_var'             => false,
	'rewrite'               => false,
	'show_in_rest'          => true,
	'rest_base'             => 'nisje-tags',
	'rest_controller_class' => 'WP_REST_Terms_Controller',
];

/**
 * Filters the taxonomy arguments for this taxonomy.
 *
 * @param array $taxonomy_args Taxonomy arguments.
 */
$taxonomy_args = apply_filters( 'nisje_taxonomy_tags_args', $taxonomy_args );

/**
 * Filters the object types to connect to this taxonomy.
 *
 * @param array Post type arguments.
 */
$object_types = apply_filters( 'nisje_taxonomy_tags_object_types', [ 'post', 'page' ] );

register_taxonomy( 'nisje-tags', $object_types, $taxonomy_args );
