<?php
/**
 * Setup Normisjon functionality
 *
 * @package Nisje
 */

declare( strict_types = 1 );

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Add menu links
 */
function nisje_normisjon_add_menu_links() {
	$tax_region = get_taxonomy( 'nisje-event-region' );
	if ( false !== $tax_region ) {
		add_menu_page( $tax_region->labels->name, $tax_region->labels->name, 'read', 'edit-tags.php?taxonomy=' . $tax_region->name, '', 'dashicons-text', 50 );
	}

	$tax_type = get_taxonomy( 'nisje-event-type' );
	if ( false !== $tax_type ) {
		add_menu_page( $tax_type->labels->name, $tax_type->labels->name, 'read', 'edit-tags.php?taxonomy=' . $tax_type->name, '', 'dashicons-text', 50 );
	}
}
add_action( 'admin_menu', 'nisje_normisjon_add_menu_links' );

/**
 * Setup taxonomies
 */
function nisje_normisjon_extend_content_types() {
	$event_component = nisje_get_component( 'event' );

	if ( $event_component ) {
		require dirname( __FILE__ ) . '/taxonomies/taxonomy-event-region.php';
		require dirname( __FILE__ ) . '/taxonomies/taxonomy-event-type.php';
	}
}
add_action( 'nisje_register_content_types', 'nisje_normisjon_extend_content_types' );

/**
 * Register Public settings
 *
 * @param array $settings Current settings.
 *
 * @return array $settings Populated settings.
 */
function nisje_normisjon_extend_public_settings( $settings ) {
	$tax_region = get_taxonomy( 'nisje-event-region' );
	if ( false !== $tax_region ) {
		$settings['taxonomies'][] = [
			'label'  => $tax_region->label,
			'labels' => $tax_region->labels,
			'name'   => $tax_region->name,
		];
	}

	$tax_type = get_taxonomy( 'nisje-event-type' );
	if ( false !== $tax_type ) {
		$settings['taxonomies'][] = [
			'label'  => $tax_type->label,
			'labels' => $tax_type->labels,
			'name'   => $tax_type->name,
		];
	}

	return $settings;
}
add_filter( 'nisje_add_public_component_settings_event', 'nisje_normisjon_extend_public_settings' );
