<?php
/**
 * Stat Cards
 *
 * @package Nisje
 */

declare( strict_types = 1 );

/**
 * Add User bookmark layout
 */
function nisje_register_stat_layout() {
	if ( ! function_exists( 'nisje_fpl_register_layout' ) ) {
		return;
	}

	nisje_fpl_register_layout(
		'stat', [
			'key'             => '5b684dq432f2rf573e',
			'label'           => esc_html__( 'Stat card', 'nisje-rs' ),
			'sub_fields'      => [
				[
					'key'          => 'field_5b4323685efhf9f4e',
					'label'        => esc_html__( 'Position', 'nisje-rs' ),
					'name'         => 'position',
					'type'         => 'number',
					'instructions' => esc_html__( 'Add the position in the feed you\'d like this card to be injected after.', 'nisje-rs' ),
					'required'     => 1,
				],
			],
			'render_callback' => function() {
				$cache_key = 'nisje_rs_stat_cache';

				$retval = get_transient( 'nisje_rs_stat_cache' );
				if ( false === $retval ) {
					$retval = '';

					$response = wp_remote_get( 'https://www.redningsselskapet.no/wp-json/rs/v1/statistics/intranett?secret=9wvU4aEUomw0ZartsuCdlb3NdblvHwUW' );
					if ( ! is_wp_error( $response ) ) {
						$values = json_decode( wp_remote_retrieve_body( $response ), true );

						$stats = '';
						if ( isset( $values['success'], $values['data'] ) && $values['success'] ) {
							$defaults = [
								'persons_assisted_current_year' => esc_html__( 'persons assisted', 'nisje-rs' ),
								'vessels_salvaged_current_year' => esc_html__( 'vessels salvaged', 'nisje-rs' ),
								'members' => esc_html__( 'members', 'nisje-rs' ),
							];

							foreach ( $defaults as $key => $translation ) {
								if ( isset( $values['data'][ $key ] ) ) {
									// translators: %1$d stat number %2$s stat text.
									$stats .= '<span className="frontpage-stats-small-number">' . sprintf( esc_html_x( '%1$d %2$s', 'stat number and string', 'nisje-rs' ), absint( $values['data'][ $key ] ), esc_html( $translation ) ) . '</span>';
								}
							}
						}

						$featured = '';
						if ( isset( $values['data']['lives_saved_current_year'] ) ) {
							$featured = sprintf(
								'<div className="frontpage-stats-featured-number">
									%d
								</div>
								<div className="frontpage-stats-featured-text">
									%s
								</div>',
								absint( $values['data']['lives_saved_current_year'] ),
								esc_html__( 'lives saved', 'nisje-rs' )
							);
						}

						if ( $stats ) {
							$retval = sprintf(
								'<div className="frontpage-stats-inner">
									<div className="frontpage-stats-logo">
										<img src="%s" alt="Redningsselskapet" />
										%s
									</div>
									%s
									<div>
										<p>
											%s
										</p>
									</div>
								</div>',
								esc_url( NISJE_RS_URL . 'assets/logo.a2d9719f.png' ),
								esc_html( gmdate( 'Y' ) ),
								$featured, // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
								$stats // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							);
						}

						set_transient( $cache_key, $retval, HOUR_IN_SECONDS );
					}
				}

				return $retval;
			},
		]
	);
}
add_action( 'nisje_fpl_register_layouts', 'nisje_register_stat_layout' );

/**
 * Add Stat CSS.
 *
 * @param string $css Current Custom CSS.
 * @return string $css Populated CSS
 */
function nisje_register_stat_css( $css ) {
	$stat_css = '
		.frontpage-stats-inner {
			padding: 75px 25px 25px;
			text-align: center;
			width: 100%;
		}

		.frontpage-stats .grid-item-inner {
			align-items: center;
			display: flex;
			justify-content: center;
		}

		.frontpage-stats-featured-number {
			color: #010082;
			font-size: 150px;
			font-weight: 900;
			line-height: 1;
		}

		.frontpage-stats-featured-text {
			font-size: 27px;
			font-weight: bold;
			margin-bottom: 30px;
		}

		.frontpage-stats-logo {
			color: #f00;
			font-size: 21px;
			font-weight: bold;
			left: 10px;
			line-height: 1;
			padding-top: 20px;
			position: absolute;
			top: 15px;
		}

		.frontpage-stats-logo img {
			margin-right: 10px;
			vertical-align: top;
			width: 110px;
		}

		.frontpage-stats-small-number {
			display: block;
		}

		@media screen and ( min-width: 600px ) {
			.frontpage-stats-inner {
				margin: 7.5% 0 0 0;
				padding: 90px 25px 40px;
			}

			.frontpage-stats-logo {
				padding: 7.5% 7.5% 0;
				left: 15px;
			}
		}
	';

	return $stat_css . $css;
}
add_filter( 'wp_get_custom_css', 'nisje_register_stat_css' );
