<?php
/**
 * Updates/Setup/Activation
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Setup plugin
 */
function nisje_user_content_check() {
	$current_plugin_version = NISJE_USER_CONTENT_VERSION;
	$option_key             = 'nisje_user_content_version';
	$installed_version      = get_option( $option_key );

	// New install.
	if ( ! $installed_version ) {
		update_option( $option_key, $current_plugin_version );

		nisje_user_content_activation();

		return;
	}

	// Do nothing if $installed_version is >= $plugin_version.
	if ( version_compare( $installed_version, $current_plugin_version, '>=' ) ) {
		return;
	} else {
		nisje_user_content_activation();

		add_action(
			'admin_notices', function () {
				?>
				<div class="notice">
					<p>
						<strong><?php echo esc_html__( 'Nisje User Content:', 'nisje-user-content' ); ?></strong>
						<?php esc_html_e( 'Plugin updated!', 'nisje-user-content' ); ?>
					</p>
				</div>
				<?php
			}
		);
	}
}
add_action( 'nisje_updates', 'nisje_user_content_check' );

/**
 * Activation
 */
function nisje_user_content_activation() {
	$option_key = 'nisje_user_content_version';

	$all_roles = nisje_get_setting( 'roles', 'core' );
	nisje_activate_roles( $all_roles, nisje_get_setting( 'capability_key', 'user-content' ) );

	$types   = nisje_get_setting( 'types', 'user-content' );
	$formats = nisje_get_setting( 'formats', 'user-content' );

	$types_tax   = nisje_get_setting( 'taxonomy_type_name', 'user-content' );
	$formats_tax = nisje_get_setting( 'taxonomy_format_name', 'user-content' );

	// Add default types.
	foreach ( $types as $slug => $name ) {
		wp_insert_term(
			$name,
			$types_tax,
			[
				'description' => '',
				'slug'        => $slug,
			]
		);
	}

	// Add default formats.
	foreach ( $formats as $slug => $name ) {
		wp_insert_term(
			$name,
			$formats_tax,
			[
				'description' => '',
				'slug'        => $slug,
			]
		);
	}

	update_option( $option_key, NISJE_USER_CONTENT_VERSION );
}
