<?php
/**
 * Plugin Name: Nisje - Wiki
 * Description: Add a wiki to Nisje
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     1.0.0
 * Text Domain: nisje-wiki
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_WIKI_VERSION', '1.0.0' );

/**
 * Load plugin textdomain.
 */
function nisje_wiki_load_textdomain() {
	load_plugin_textdomain( 'nisje-wiki', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_wiki_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_wiki_include() {
	require __DIR__ . '/wiki/wiki.php';
}
add_action( 'nisje_include', 'nisje_wiki_include' );
